%%%% Fig.10 computing power allocations in higher SNR regions %%%%%%

clear all
clc

load optimal_kappa_2 SNR
load optimal_kappa_4 SNR
load optimal_kappa_8 SNR
load optimal_kappa_8choose2

figure(1)
yyaxis left
plot(SNR, kappa2, 'b-o','Linewidth',2)
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR (dB)','FontSize',10,'FontWeight','bold');
ylabel('Optimal \kappa','FontSize',10,'FontWeight','bold')
yyaxis right

plot(SNR, R_secJ2, 'r-^','Linewidth',2)
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR (dB)','FontSize',10,'FontWeight','bold');
ylabel('Secrecy Rate','FontSize',10,'FontWeight','bold')
axis tight

legend('N_t=2, n_t=1, Opt. \kappa','N_t=2, n_t=1, Sec. Rat.')
legend('Location','east')

figure(2)
yyaxis left
plot(SNR, kappa4, 'b-o', 'Linewidth',2)
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR (dB)','FontSize',10,'FontWeight','bold');
ylabel('Optimal \kappa','FontSize',10,'FontWeight','bold')

yyaxis right
plot(SNR, R_secJ4, 'r-^', 'Linewidth',2)
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR (dB)','FontSize',10,'FontWeight','bold');
ylabel('Secrecy Rate','FontSize',10,'FontWeight','bold')
axis tight

legend('N_t=4, n_t=1, Opt. \kappa','N_t=4, n_t=1, Sec. Rat.')
legend('location','east')

figure(3)
yyaxis left
plot(SNR, kappa8,  'b-o', 'Linewidth',2)
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR (dB)','FontSize',10,'FontWeight','bold');
ylabel('Optimal \kappa','FontSize',10,'FontWeight','bold')

yyaxis right
plot(SNR, R_secJ8, 'r-^', 'Linewidth',2)
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR (dB)','FontSize',10,'FontWeight','bold');
ylabel('Secrecy Rate','FontSize',10,'FontWeight','bold')
axis tight

legend('N_t=8, n_t=1, Opt. \kappa','N_t=8, n_t=1, Sec. Rat.')
legend('location','east')

figure(4)
yyaxis left
plot(SNR, kappa8choose2,  'b-o', 'Linewidth',2)
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR (dB)','FontSize',10,'FontWeight','bold');
ylabel('Optimal \kappa','FontSize',10,'FontWeight','bold')

yyaxis right
plot(SNR, R_secJ8choose2, 'r-^', 'Linewidth',2)
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR (dB)','FontSize',10,'FontWeight','bold');
ylabel('Secrecy Rate','FontSize',10,'FontWeight','bold')
axis tight

legend('N_t=8, n_t=2, Opt. \kappa','N_t=8, n_t=2, Sec. Rat.')
legend('Location','east')
